REBOL [
    title: "ImmobilierNet Module agence - edition des clients"
    version: 1.0
    author: "Olivier Auverlot"
]

clients: make object! [

    edition-client: layout [
        backtile 192.192.192
        across
        text "Numro de dossier:"
        dossier: text 100
        return
        below
        panel [
            origin 0x0
            size 300x320
            origin 0x0
            text "Nom :"
            nom: field 250 ""
            text "Prnom :"
            prenom: field 250 ""
            text "Adresse :"
            adr1: field 250 ""
            adr2: field 250 ""
            across
            text "CP :"
            cp: field 60
            text "Tel :"
            tel: field 100 ""  
            return
            text "Ville :"
            ville: field 200 ""    
        ]
        return
        panel [
            origin 0x0
            size 250x320
            across
            text "Budget :"
            budget: field 100 ""
            return
            text "Chambres :"
            chambres: field 100 ""
            return
            style-bien: info 150 "" 
            button 50 "Style" [
                rep: request-list "Style du bien" styles-bien
                if not none? rep [
                    style-bien/text: rep
                    show style-bien
                ]
            ]
            return            
            zonegeo: info 150 ""            
            button 50 "Zone" [
                rep: request-list "Zone gographique" zones                
                if not none? rep [
                    zonegeo/text: rep
                    show zonegeo
                ]
            ]
            below
            button 200 "Rechercher" [ 
                browse make url! join "http://mars/immobiliernet/zones.cgi?" [
                    "chambres=" chambres/text "&"
                    "budget=" budget/text "&"
                    "style=" (pick num-styles numstyle) 
                ]
            ]
            text "Annotations :"
            remarques: area 200x50 "" wrap
            pad 30
            across
            button "Annuler" [ unview edition-client ]
            button "Valider" [ enregistre-client ]
        ]
    ] 

    enregistre-client: does [        
        numstyle: where styles-bien (trim style-bien/text)
        numzone: where zones (trim zonegeo/text)
        ; l'utilisateur a t'il slectionn un style, une zone gographique et un budget
        either all [ 
            (not none? numstyle)
            (not none? numzone)
            ((length? (trim to-string budget/text)) > 0)
        ] [                                    
            either (none? num) [
                ; cration d'un dossier
                envoi-sql join "INSERT INTO clients " [
                    "( nom,prenom,adr1,adr2,code_postal,ville,telephone,budget,style,chambres,zonegeo,remarques)"
                    " values ('" nom/text "','" prenom/text 
                    "','" adr1/text "','" adr2/text "','" 
                    cp/text "','" ville/text "','" 
                    tel/text "'," (trim budget/text) ","
                    (pick num-styles numstyle) "," (trim chambres/text) ","
                    (pick num-zones numzone) ",'" remarques/text "')"    
                ]
                menu-principal/charge-table 1              
                unview edition-client
            ] [                                
                ; modification d'un dossier                              
                envoi-sql join "UPDATE clients " [
                    "SET nom='" nom/text "',"
                    "prenom='" prenom/text "',"
                    "adr1='" adr1/text "',"
                    "adr2='" adr2/text "',"
                    "code_postal='" cp/text "',"
                    "ville='" ville/text "',"
                    "telephone='" tel/text "',"
                    "budget=" budget/text ","
                    "style=" (pick num-styles numstyle) ","
                    "chambres=" chambres/text ","
                    "zonegeo=" (pick num-zones numzone) ","
                    "remarques='" remarques/text "'" 
                    " WHERE num=" num
                ]
                unview edition-client
            ]
        ] [ request/ok "Vous devez slectionner un style, un budget et une zone" ]
    ]
    
    
    start: function [ n ] [] [ 
        ; cl du client
        num: n

        ; lecture des nomenclatures
        styles-bien: copy [] 
        zones: copy []

        ; chargement des styles
        envoi-sql "SELECT * FROM styles ORDER BY intitule" 
        ; stockage des cls primaires
        num-styles: copy []    
        foreach ele buffer [
            append num-styles (to-integer ele/1)
            append styles-bien (trim ele/2)
        ]
        
        ; chargement des zones
        envoi-sql "SELECT * FROM zonesgeo ORDER BY intitule"
        num-zones: copy []
        foreach ele buffer [
            append num-zones (to-integer ele/1)
            append zones (trim ele/2)
        ]
        
        ; cration ou dition d'un dossier ?
        either not none? num [
            dossier/text: num
            envoi-sql join "SELECT * FROM clients WHERE num=" num
            nom/text: trim buffer/1/2
            prenom/text: trim buffer/1/3
            adr1/text: trim buffer/1/4
            adr2/text: trim buffer/1/5
            cp/text: trim buffer/1/6
            ville/text: trim buffer/1/7
            tel/text: trim buffer/1/8
            budget/text: buffer/1/9
            chambres/text: buffer/1/11
            numstyle: make integer! buffer/1/10
            numzone: make integer! buffer/1/12
            remarques/text: buffer/1/13       
            zonegeo/text: pick zones (index? find num-zones numzone)
            style-bien/text: pick styles-bien (index? find num-styles numstyle)
        ] [ 
            dossier/text: "(nouveau)" 
            numstyle: numzone: none
            nom/text: copy ""
            prenom/text: copy ""
            adr1/text: copy "" 
            adr2/text: copy ""
            cp/text: copy ""
            ville/text: copy ""
            tel/text: copy ""
            budget/text: copy ""
            chambres/text: copy ""
            zonegeo/text: copy ""
            style-bien/text: copy ""
            remarques/text: copy ""           
        ]
        view/new edition-client      
    ]
]
